Rem
Rem $Header: scale_georaster.sql 05-aug-2004.09:30:23 wexu Exp $
Rem
Rem scale_georaster.sql
Rem
Rem Copyright (c) 2002, 2004, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      scale_georaster.sql 
Rem
Rem    DESCRIPTION
Rem      scale means enlarge or shrink georaster objects
Rem
Rem    NOTES
Rem      
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    wexu        08/05/04 - RDT must be unique 
Rem    qxie        09/24/03 - optionally add rasterid in init() call 
Rem    wexu        11/04/02 - minor fixes
Rem    qxie        10/31/02 - qxie_demo1
Rem    qxie        10/30/02 - Created
Rem


-------------------------------------------------------------------
-- scale and scaleCopy GeoRaster Objects
-- 
-- Enlarge or shrink georaster objects.
-- It can scale a georaster object at different scale factors along
-- different dimensions. You can also choose different resampling.
-- The storage format for the results can be specified freely.
-------------------------------------------------------------------

declare
  gr1 mdsys.sdo_georaster;
  gr2 mdsys.sdo_georaster;
  cnt integer := 0;
begin
  --
  -- enlarge a truecolor georaster object
  --

  -- 1. initialize an empty georaster to hold the scaled copy
  delete from georaster_table where georid = 10;
  insert into georaster_table
    values (10, 'Blank Subset', sdo_geor.init('ST_RDT_4', 10))
    returning georaster into gr2;

  -- 2. the source 3-band truecolor georaster object
  select georaster into gr1 from georaster_table where georid = 4;

  -- 3. enlarge 2 times 
  sdo_geor.scaleCopy(gr1, 'scaleFactor=2', 'resampling=BILINEAR',
                     'blocksize=(256,256,3) interleaving=BIP', gr2);

  -- 4. store it into the georaster table
  update georaster_table set georaster = gr2 where georid = 10;

  commit;
end;
/

-- quick check on the results
@query_georaster.sql
